function NavNodeAPI(navEngine)
{
	this._winRef = window;
	this.navEngine = navEngine;
}
NavNodeAPI.prototype.canGotoNode = NavNodeAPICanGotoNode;
NavNodeAPI.prototype.gotoNode = NavNodeAPIGotoNode;
NavNodeAPI.prototype.gosubNode = NavNodeAPIGosubNode;
NavNodeAPI.prototype.canContinue = NavNodeAPICanNext;
NavNodeAPI.prototype.canPrevious = NavNodeAPICanBack;
NavNodeAPI.prototype.navContinue = NavNodeAPINavContinue;
NavNodeAPI.prototype.navPrevious = NavNodeAPINavBack;
NavNodeAPI.prototype.setNodeScore = NavNodeAPISetScore;
NavNodeAPI.prototype.getNodeScore = NavNodeAPIGetScore;
NavNodeAPI.prototype.getNodeChildIds = NavNodeAPIGetChildIds;
NavNodeAPI.prototype.getNodeTitle = NavNodeAPIGetTitle;
NavNodeAPI.prototype.getNodeUrl = NavNodeAPIGetUrl;
NavNodeAPI.prototype.getNodeTag = NavNodeAPIGetTag;
NavNodeAPI.prototype.getBooleanProperty = NavNodeAPIGetBooleanProperty;
NavNodeAPI.prototype.setBooleanProperty = NavNodeAPISetBooleanProperty
NavNodeAPI.prototype.getNodeAttempted = NavNodeAPIGetAttempted;
NavNodeAPI.prototype.setNodeAttempted = NavNodeAPISetAttempted;
NavNodeAPI.prototype.getNodeCompleted = NavNodeAPIGetCompleted;
NavNodeAPI.prototype.setNodeCompleted = NavNodeAPISetCompleted;
NavNodeAPI.prototype.getNodeSatisfied = NavNodeAPIGetSatisfied;
NavNodeAPI.prototype.setNodeSatisfied = NavNodeAPISetSatisfied;
NavNodeAPI.prototype.getNodeSkip = NavNodeAPIGetSkip;
NavNodeAPI.prototype.setNodeSkip = NavNodeAPISetSkip;
NavNodeAPI.prototype.getNodeChoice = NavNodeAPIGetChoice;
NavNodeAPI.prototype.setNodeChoice = NavNodeAPISetChoice;
NavNodeAPI.prototype.getNodeFlow = NavNodeAPIGetFlow;
NavNodeAPI.prototype.setNodeFlow = NavNodeAPISetFlow;
NavNodeAPI.prototype.getNodeForwardOnly = NavNodeAPIGetForwardOnly;
NavNodeAPI.prototype.setNodeForwardOnly = NavNodeAPISetForwardOnly;
NavNodeAPI.prototype.getNodeBlock = NavNodeAPIGetBlock;
NavNodeAPI.prototype.setNodeBlock = NavNodeAPISetBlock;
NavNodeAPI.prototype.getNodeEnabled = NavNodeAPIGetEnabled;
NavNodeAPI.prototype.setNodeEnabled = NavNodeAPISetEnabled;
NavNodeAPI.prototype.getNodeVisible = NavNodeAPIGetVisible;
NavNodeAPI.prototype.setNodeVisible = NavNodeAPISetVisible;
NavNodeAPI.prototype.resetNode = NavNodeAPIResetNode;
NavNodeAPI.prototype.refreshNode = NavNodeAPIRefreshNode;
NavNodeAPI.prototype.getNodeId = NavNodeAPIGetNodeId;
NavNodeAPI.prototype.getNodeRef = NavNodeAPIGetNodeRef;
NavNodeAPI.prototype.verifyUrl = NavNodeAPIVerifyUrl;
NavNodeAPI.prototype.registerEvent = NavNodeAPIRegisterEvent;
NavNodeAPI.prototype.unregisterEvent = NavNodeAPIUnregisterEvent;
NavNodeAPI.prototype.getChoice = NavNodeAPIGetChoice;
NavNodeAPI.prototype.getFlow = NavNodeAPIGetFlow;

function NavNodeAPIGetChoice()
{
	return this.navEngine.getChoice();
}

function NavNodeAPIGetFlow()
{
	return this.navEngine.getFlow();
}

function NavNodeAPIRegisterEvent(strEvent, strEvtHandler, evtContext)
{
	return this.navEngine.registerEvent(strEvent, strEvtHandler, evtContext);
}

function NavNodeAPIUnregisterEvent(callbackId)
{
	return this.navEngine.unregisterEvent(callbackId);
}

function NavNodeAPICanGotoNode(id)
{
	return (this.navEngine.canGotoNode(id));
}

function NavNodeAPIGotoNode(id)
{
	this.navEngine.gotoNode(id);
}

function NavNodeAPIGosubNode(id, retId)
{
	this.navEngine.gosubNode(id, retId);
}

function NavNodeAPICanNext()
{
	return (this.navEngine.canNav(NAV_DIRECTION_FORWARD));
}

function NavNodeAPICanBack()
{
	return (this.navEngine.canNav(NAV_DIRECTION_REVERSE));
}

function NavNodeAPINavContinue()
{
	this.navEngine.doNav(NAV_DIRECTION_FORWARD);
}

function NavNodeAPINavBack()
{
	this.navEngine.doNav(NAV_DIRECTION_REVERSE);
}

function NavNodeAPISetScore(id, score)
{
	if (arguments.length == 1)
	{
		score = id;
		id = this.navEngine.getCurrentNode().id;
	}
	this.navEngine.setNodeScore(id, score);
}

function NavNodeAPIGetScore(id)
{
	var currentNode = navEngine.getCurrentNode();
	if (currentNode != null)
	{
		if (id == null)
		{
			id = currentNode.id;
		}
		return this.navEngine.getNodeScore(id);
	}
	else
	{
		return 0;
	}
}

function NavNodeAPIGetChildIds(id)
{
	if (id == null)
	{
		id = this.navEngine.getCurrentNode().id;
	}
	return this.navEngine.getNodeChildIds(id);
}

function NavNodeAPIGetTitle(id)
{
	var currentNode = navEngine.getCurrentNode();
	if (currentNode != null)
	{
		if (id == null)
		{
			id = currentNode.id;
		}
		return this.navEngine.getNodeTitle(id);
	}
	else
	{
		return "";
	}
}

function NavNodeAPIGetUrl(id)
{
	var currentNode = navEngine.getCurrentNode();
	if (currentNode != null)
	{
		if (id == null)
		{
			id = currentNode.id;
		}
		return this.navEngine.getNodeUrl(id);
	}
	else
	{
		return "";
	}
}

function NavNodeAPIGetTag(id)
{
	var currentNode = navEngine.getCurrentNode();
	if (currentNode != null)
	{
		if (id == null)
		{
			id = currentNode.id;
		}
		return this.navEngine.getNodeTag(id);
	}
	else
	{
		return "";
	}
}

function NavNodeAPIGetBooleanProperty(prop, id)
{
	var currentNode = navEngine.getCurrentNode();
	if (currentNode != null)
	{
		if (id == null)
		{
			id = currentNode.id;
		}
		switch (prop)
		{
			case PROP_ATTEMPTED:return (this.navEngine.getNodeAttempted(id));
			case PROP_COMPLETED:return (this.navEngine.getNodeCompleted(id));
			case PROP_SATISFIED:return (this.navEngine.getNodeSatisfied(id));
			case PROP_SKIP:return (this.navEngine.getNodeSkip(id));
			case PROP_BLOCK:return (this.navEngine.getNodeBlock(id));
			case PROP_ENABLED:return (this.navEngine.getNodeEnabled(id));
			case PROP_VISIBLE:return (this.navEngine.getNodeVisible(id));
			case PROP_CHOICE:return (this.navEngine.getNodeChoice(id));
			case PROP_FLOW:return (this.navEngine.getNodeFlow(id));
			case PROP_FORWARD_ONLY:return (this.navEngine.getNodeForwardOnly(id));
			default:return false;
		}
	}
	else
	{
		return false;
	}
}

function NavNodeAPISetBooleanProperty(prop, flag, id)
{
	if (id == null)
	{
		id = this.navEngine.getCurrentNode().id;
	}
	switch (prop)
	{
		case PROP_ATTEMPTED:this.navEngine.setNodeAttempted(id, flag);break;
		case PROP_COMPLETED:this.navEngine.setNodeCompleted(id, flag);break;
		case PROP_SATISFIED:this.navEngine.setNodeSatisfied(id, flag);break;
		case PROP_SKIP:this.navEngine.setNodeSkip(id, flag);break;
		case PROP_BLOCK:this.navEngine.setNodeBlock(id, flag);break;
		case PROP_ENABLED:this.navEngine.setNodeEnabled(id, flag);break;
		case PROP_VISIBLE:this.navEngine.setNodeVisible(id, flag);break;
		case PROP_CHOICE:this.navEngine.setNodeChoice(id, flag);break;
		case PROP_FLOW:this.navEngine.setNodeFlow(id, flag);break;
		case PROP_FORWARD_ONLY:this.navEngine.setNodeForwardOnly(id, flag);break;
	}
}

function NavNodeAPIGetAttempted(id)
{
	return this.getBooleanProperty(PROP_ATTEMPTED, id);
}

function NavNodeAPISetAttempted(id, flag)
{
	if (arguments.length == 1)
	{
		flag = id;
		id = null;
	}
	this.setBooleanProperty(PROP_ATTEMPTED, flag, id);
}

function NavNodeAPIGetCompleted(id)
{
	return this.getBooleanProperty(PROP_COMPLETED, id);
}

function NavNodeAPISetCompleted(id, flag)
{
	if (arguments.length == 1)
	{
		flag = id;
		id = null;
	}
	this.setBooleanProperty(PROP_COMPLETED, flag, id);
}

function NavNodeAPIGetSatisfied(id)
{
	return this.getBooleanProperty(PROP_SATISFIED, id);
}

function NavNodeAPISetSatisfied(id, flag)
{
	if (arguments.length == 1)
	{
		flag = id;
		id = null;
	}
	this.setBooleanProperty(PROP_SATISFIED, flag, id);
}

function NavNodeAPIGetSkip(id)
{
	return this.getBooleanProperty(PROP_SKIP, id);
}

function NavNodeAPISetSkip(id, flag)
{
	if (arguments.length == 1)
	{
		flag = id;
		id = null;
	}
	this.setBooleanProperty(PROP_SKIP, flag, id);
}

function NavNodeAPIGetChoice(id)
{
	return this.getBooleanProperty(PROP_CHOICE, id);
}

function NavNodeAPISetChoice(id, flag)
{
	if (arguments.length == 1)
	{
		flag = id;
		id = null;
	}
	this.setBooleanProperty(PROP_CHOICE, flag, id);
}

function NavNodeAPIGetFlow(id)
{
	return this.getBooleanProperty(PROP_FLOW, id);
}

function NavNodeAPISetFlow(id, flag)
{
	if (arguments.length == 1)
	{
		flag = id;
		id = null;
	}
	this.setBooleanProperty(PROP_FLOW, flag, id);
}

function NavNodeAPIGetForwardOnly(id)
{
	return this.getBooleanProperty(PROP_FORWARD_ONLY, id);
}

function NavNodeAPISetForwardOnly(id, flag)
{
	if (arguments.length == 1)
	{
		flag = id;
		id = null;
	}
	this.setBooleanProperty(PROP_FORWARD_ONLY, flag, id);
}

function NavNodeAPIGetBlock(id)
{
	return this.getBooleanProperty(PROP_BLOCK, id);
}

function NavNodeAPISetBlock(id, flag)
{
	if (arguments.length == 1)
	{
		flag = id;
		id = null;
	}
	this.setBooleanProperty(PROP_BLOCK, flag, id);
}

function NavNodeAPIGetEnabled(id)
{
	return this.getBooleanProperty(PROP_ENABLED, id);
}

function NavNodeAPISetEnabled(id, flag)
{
	if (arguments.length == 1)
	{
		flag = id;
		id = null;
	}
	this.setBooleanProperty(PROP_ENABLED, flag, id);
}

function NavNodeAPIGetVisible(id)
{
	return this.getBooleanProperty(PROP_VISIBLE, id);
}

function NavNodeAPISetVisible(id, flag)
{
	if (arguments.length == 1)
	{
		flag = id;
		id = null;
	}
	this.setBooleanProperty(PROP_VISIBLE, flag, id);
}

function NavNodeAPIResetNode(id)
{
	if (id == null)
	{
		this.navEngine.resetNode(this.navEngine.getCurrentNode().id);
	}
	else
	{
		this.navEngine.resetNode(id);
	}
}

function NavNodeAPIRefreshNode()
{
	this.navEngine.showCurrent();
}

function NavNodeAPIGetNodeId(nRef)
{
	if (nRef == null)
	{
		nRef = this.navEngine.getCurrentNode();
	}
	return this.navEngine.getNodeId(nRef);
}

function NavNodeAPIGetNodeRef(id)
{
	if (id == null)
	{
		id = this.navEngine.getCurrentNode().id;
	}
	return this.navEngine.getNodeById(id);
}

function NavNodeAPIVerifyUrl()
{
	var currentNode = this.navEngine.getCurrentNode();
	var currentUrl = unescape(this.navEngine.navWin.document.URL).toLowerCase().replace(/\\/g,"/");
	var correctUrl = ((currentNode==null)?("*****"):(unescape(currentNode.url).toLowerCase().replace(/\\/g,"/")));
	var intIndex = correctUrl.lastIndexOf("./");
	if (intIndex >= 0)
	{
		correctUrl = correctUrl.slice(intIndex+2,correctUrl.length);
	}
	intIndex = currentUrl.indexOf(correctUrl);
		
	if (intIndex < 0)
	{
		if (this.navEngine.illegalNavMessage != "")
		{
			//alert(this.navEngine.illegalNavMessage);
		}
		this.navEngine.showCurrent();
	}
}
